########################### Adv Long Example 5a using R #########################

# Set width of output and number of significant digits printed,
# number of digits before using scientific notation, shut off significance stars
options(width=120, digits=8, scipen=9, show.signif.stars=FALSE)

#####  Check to see if packages are downloaded, install if not, then load  #####

if (!require("readxl")) install.packages("readxl")
library(readxl) # To import xls or xlsx data as table

if (!require("TeachingDemos")) install.packages("TeachingDemos")
library(TeachingDemos) # To create text output files

# To estimate MLMs using lmer
# Re-install to fix problem of matrix incompatibility
#oo <- options(repos = "https://cran.r-project.org/")
#utils::install.packages("Matrix")
#utils::install.packages("lme4")
#options(oo)
library(Matrix); library(lme4)

if (!require("lmerTest")) install.packages("lmerTest")
library(lmerTest) # To get Satterthwaite DDF in lmer

if (!require("performance")) install.packages("performance")
library(performance) # To get ICC in lmer

if (!require("lavaan")) install.packages("lavaan")
library(lavaan) # To fit SEMs

# Clear environment (run as needed)
#rm(list=ls())


################################################################################
#####             BEGIN DATA MANIPULATION OF EXAMPLE 5a                    #####
#####              CHANGE "filesave" TO YOUR DIRECTORY                     #####
################################################################################

# Set working directory (to import and export files to)
setwd("C:/Dropbox/25_PSQF7375_AdvLong/PSQF7375_AdvLong_Example5a")

# Import Example5a stacked data from excel in sheet "Data"
Example5a = read_excel(path="AdvLong_Example5a.xlsx", sheet="Data") 
# Convert to data frame to use in analysis
Example5a = as.data.frame(Example5a)

# Relabel stressor variables to match Mplus syntax
Example5a$stress = Example5a$stressor
Example5a$PMstr40 = Example5a$PMstress40
# Create level-2 interaction for MSEM versions
Example5a$agesex = Example5a$age80*Example5a$women

# Open output text file
txtStart(file="AdvLong_Example5a_R_Output.txt")


################################################################################
#####           BEGIN MULTILEVEL MODELS FOR EXAMPLE 5a STACKED DATA        #####
################################################################################


print("Step 0: Empty Models for Continu-ish Symptoms and Mood")
EmptyY = lmer(data=Example5a, REML=FALSE, formula=symptoms~1+(1|PersonID))
summary(EmptyY); icc(EmptyY)

EmptyM = lmer(data=Example5a, REML=FALSE, formula=mood2~1+(1|PersonID))
summary(EmptyM); icc(EmptyM)

print("Step 0: Empty Model for Binary Stressors")
print("Using logit link and 15 quadrature points to match Mplus")
EmptyX = glmer(data=Example5a, family=binomial(link="logit"), nAGQ=15, formula=stressor~1+(1|PersonID))
summary(EmptyX); icc(EmptyX)

txtComment(" ") # insert blank space in output


print("Step 1a: X Stressors Predicting Symptoms Y using Univ MLM")
Step1 = lmer(data=Example5a, REML=FALSE, 
             formula=symptoms~1+women+age80+stressor+PMstress40+women:age80+(1|PersonID))
print("Show results using Satterthwaite DDF") 
summary(Step1, ddf="Satterthwaite")
print("BP X to Y Effect"); contest1D(Step1, ddf="Satterthwaite", L=c(0,0,0,1,1,0)) 

txtComment(" ") # insert blank space in output


print("Step 1b: X Stressors Predicting Symptoms Y using Multiv MLM -- No Placeholder Version")
Step1bSyntax = "
level: 1
# L1 R: residual variance in symptoms
  symptoms ~~ symptoms
# L1 WP stress -> symptoms
  symptoms ~ (WPXtoY)*stress

level: 2
# Fixed intercepts for symptoms
  symptoms ~ 1
# L2 G: random intercept variance in symptoms
  symptoms ~~ symptoms
# BP fixed effects of women*age80 -> symptoms
  symptoms ~ women + age80 + agesex
# Contextual fixed effect of stress -> symptoms
  symptoms ~ (conXtoY)*PMstr40
# Create BP fixed effect of stress -> symptoms
  BPXtoY := conXtoY + WPXtoY
"
Step1bMSEM = sem(data=Example5a, model=Step1bSyntax, cluster="PersonID", estimator="ML", mimic="mplus")
summary(Step1bMSEM, fit.measures=TRUE)

txtComment(" ") # insert blank space in output


print("Step 2a-ish: M Mood Predicting Symptoms Y using Univ MLM")
Step2 = lmer(data=Example5a, REML=FALSE, 
             formula=symptoms~1+women+age80+mood2+PMmood2+women:age80+(1|PersonID))
print("Show results using Satterthwaite DDF") 
summary(Step2, ddf="Satterthwaite")
print("BP M to Y Effect"); contest1D(Step2, ddf="Satterthwaite", L=c(0,0,0,1,1,0)) 

txtComment(" ") # insert blank space in output


print("Step 2b: M Mood Predicting Symptoms Y using Multiv MLM -- No Placeholder Version")
Step2bSyntax = "
level: 1
# L1 R: residual variance in symptoms and mood
  symptoms ~~ symptoms; mood2 ~~ mood2
# L1 WP mood -> symptoms
  symptoms ~ (WPMtoY)*mood2

level: 2
# Fixed intercepts for symptoms and mood
  symptoms ~ 1; mood2 ~ 1 
# L2 G: random intercept variance in symptoms and mood
  symptoms ~~ symptoms; mood2 ~~ mood2
# BP fixed effects of women*age80 -> symptoms
  symptoms ~ women + age80 + agesex
# BP fixed effect of mood -> symptoms
  symptoms ~ (BPMtoY)*mood2
# Create contextual fixed effect of mood -> symptoms
  conMtoY := BPMtoY - WPMtoY
"
Step2bMSEM = sem(data=Example5a, model=Step2bSyntax, cluster="PersonID", estimator="ML", mimic="mplus")
summary(Step2bMSEM, fit.measures=TRUE)

txtComment(" ") # insert blank space in output


print("Step 3a: Full mediation MLM of Stress --> Mood --> Symptoms -- No Placeholder Version")
Step3aSyntax = "
level: 1
# L1 R: residual variance in symptoms and mood
  symptoms ~~ symptoms; mood2 ~~ mood2
# L1 WP stress -> mood
  mood2 ~ (WPXtoM)*stress
# L1 WP stress -> symptoms
  symptoms ~ (WPXtoY)*stress
# L1 WP mood -> symptoms
  symptoms ~ (WPMtoY)*mood2

level: 2
# Fixed intercepts for symptoms and mood
  symptoms ~ 1; mood2 ~ 1 
# L2 G: random intercept variance in symptoms and mood
  symptoms ~~ symptoms; mood2 ~~ mood2
# BP fixed effects of women*age80 -> symptoms
  symptoms ~ women + age80 + agesex
# BP fixed effects of women*age80 -> mood
  mood2 ~ women + age80 + agesex 
# Contextual effect of stress -> symptoms
  mood2 ~ (conXtoM)*PMstr40
# Contextual effect of stress -> symptoms
  symptoms ~ (conXtoY)*PMstr40
# BP fixed effect of mood -> symptoms
  symptoms ~ (BPMtoY)*mood2

# Create contextual fixed effect of mood -> symptoms
  conMtoY := BPMtoY - WPMtoY
# Create BP fixed effects of stress -> mood and symptoms
  BPXtoM := conXtoM + WPXtoM
  BPXtoY := conXtoY + WPXtoY
# Create indirect effects
  WPind  := WPXtoM*WPMtoY
  Conind := conXtoM*conMtoY
  BPind  := BPXtoM*BPMtoY
"
Step3aMSEM = sem(data=Example5a, model=Step3aSyntax, cluster="PersonID", estimator="ML", mimic="mplus")
summary(Step3aMSEM, fit.measures=TRUE)


# Close output text file
txtStop()
